// www.mm65.de (c) 2013

/** Handling of command line arguments. */
class StartParams {

    int threadCount;
    int busySeconds;
    String error;

    /**
     * Parses the passed arguments. If there was a problem,
     * the member <code>error</code> is set. If it is <code>null</code>,
     * all is ok.
     */
    StartParams(final String[] args) {
        error = null;
        if (args.length != 2) {
            error = "ERROR: " + args.length
                    + " arguments were given but exactly 2 are required.";
            return;
        }

        try {
            threadCount = Integer.parseInt(args[0]);
        } catch (NumberFormatException e) {
            error = "ERROR parsing threadCount '" + args[0] + "':"
                    + e.getMessage();
            return;
        }

        try {
            busySeconds = Integer.parseInt(args[1]);
        } catch (NumberFormatException e) {
            error = "ERROR parsing busySeconds '" + args[1] + "':"
                    + e.getMessage();
            return;
        }
    }

    static String showUsage() {
        StringBuilder sb = new StringBuilder();
        String newLine = System.lineSeparator();
        sb.append("USAGE:");
        sb.append(newLine);
        sb.append("    java -jar StartThreads.jar <countOfThreadsToStart> <busySeconds>");
        sb.append(newLine);
        sb.append("EXAMPLE:");
        sb.append(newLine);
        sb.append("    java -jar StartThreads.jar 1000 60");
        sb.append(newLine);
        return sb.toString();
    }

}